
/***********************************************************************************************
This do file outputs all tables for district-level expenditure data;
***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
set more off;
clear matrix;
set mem 500M;
estimates clear;
set matsize 800;

global final_data "C:/Users/nschwart/Desktop/nclb_final/ccd_folder/final_data";
global tables "C:/Users/nschwart/Desktop/nclb_final/ccd_folder/tables";

/*Collect outcomes*/
global expenditures "tcurelscpp tcurinstpp tcurssvcpp tcurothpp";
global revenues "total_rev tfedrevpp stlocrevpp";
global exprev "tcurelscpp tcurinstpp tcurssvcpp tcurothpp total_rev tfedrevpp stlocrevpp";
 
 use "$final_data/dist_expend.dta", clear;
 
 gen total_rev = tfedrevpp+stlocrevpp;
 gen logtotal_rev = log(total_rev);
 
/*Run expenditure regressions*/

foreach h of global exprev {;
 quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "CovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
[aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "noCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
, absorb(state) cl(state);
 eststo, title("lev`h'", "noCovnoWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg log`h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("log`h'", "CovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se);
 quietly sum `h' if fiscalyear==2000 [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

estout * using "$tables/Exprev_CITS.txt", 
drop(*) starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/************Now run falsification******************/

estimates clear;
global falsification "st_povpct st_hhinc st_emppop st_frac_enroll st_pct_black st_pct_hisp";

replace st_povpct=st_povpct*100;
replace st_emppop=st_emppop*100;
replace st_pct_black = st_pct_black;
replace st_pct_hisp = st_pct_hisp;

foreach h of global falsification {;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   [aw=enrollment], absorb(state) cl(state);
 eststo, title("`h'", "No Covariates");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if fiscalyear==2000 [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
 
};


estout * using "$tables/Exprev_falsification.txt", 
drop(*)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

/***************Run regressions on selected expenditure outcomes for separate poverty quartiles*************/

estimates clear;

foreach h of global exprev {;
 foreach l in 1 2 3 4 {;
  quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  if pov_quart==`l'
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("`l'`h'", "CovWgt"); 
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if fiscalyear==2000 & pov_quart==`l' [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};
};

estout * using "$tables/exprevpov_CITS.txt", 
drop(*) starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

/*******************Run specification checks*******************/

estimates clear;

/****************Quadratic pre-trend****************/

/*Run expenditure regressions*/


foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "CovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since 
[aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "noCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since 
, absorb(state) cl(state);
 eststo, title("lev`h'", "noCovnoWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if fiscalyear==2000 [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};


estout * using "$tables/exprev_quadCITS.txt", 
drop(*) starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/*******************************Omitting first two years of data*****************************************/

estimates clear;

/*Run expenditure regressions*/

foreach h of global exprev {;
  quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov if omityears_sample==1
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "CovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
  quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
 if omityears_sample==1 [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "noCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
  quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
 if omityears_sample==1, absorb(state) cl(state);
 eststo, title("lev`h'", "noCovnoWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if fiscalyear==2000 [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
 };

estout * using "$tables/exprev_omitCITS.txt", 
drop(*) starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

/****************************NAEP Sample****************************************************************************/

estimates clear;

/*Run expenditure regressions*/

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov if naep_sample==1
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "CovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since 
 if naep_sample==1 [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "noCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since 
 if naep_sample==1, absorb(state) cl(state);
 eststo, title("lev`h'", "noCovnoWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if fiscalyear==2000 [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

estout * using "$tables/exprev_naepCITS.txt", 
drop(*) starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;



/***********One last spec check -- won't be used as final table -- add state-level covariates and see whether anything changes**********/

estimates clear;

/*Run regressions adding in various different state-level covariates*/
/*List of covariates: st_povpct st_hhinc st_emppop st_frac_enroll st_pct_black st_pct_hisp*/

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_povpct
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "povpctCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_hhinc
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "hhincCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_emppop
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "emppopCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_frac_enroll
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "fracenrollCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_pct_black st_pct_hisp
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "pctblackCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};


foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_povpct
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "povpctnoCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_hhinc
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "hhincnoCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_emppop
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "emppopnoCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_frac_enroll
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "fracenrollnoCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

foreach h of global exprev {;
 quietly areg `h' year year_sq nclb yr_since_nclb NEWTREAT_year NEWTREAT_year_sq NEWTREAT_nclb NEWTREAT_yr_since  
 st_pct_black st_pct_hisp
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("lev`h'", "pctblacknoCovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

estout * using "$tables/exprev_stcovCITS.txt", 
keep(st_povpct st_hhinc st_emppop st_frac_enroll st_pct_black st_pct_hisp) cells(b(star) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;
